/**
* \file: CarPlayControlClientHooks.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: Pradeepa Govindaraju \ Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "Common.h"
#include "Server.h"
#include "CarPlayControlClient.h"
using namespace adit::carplay;

extern "C" {

CARPLAY_EXPORTED void    _CarPlayControlClientEventCallback(CarPlayControllerRef inController, bool inStatus);


void    _CarPlayControlClientEventCallback(CarPlayControllerRef inController, bool inStatus)
{
    const char *cStrDeviceName = NULL;
    const char *cStrDeviceVersion = NULL;
    char btBuf[256]={0};
    char *storage = NULL;
    CFStringRef name = NULL;
    uint8_t btMac[6]={0};
    CFStringRef version = NULL;
    CarPlayDevice *deviceCarplay = NULL;

    CarPlayControllerCopyName(inController, &name);
    CFStringGetOrCopyCStringUTF8(name, &cStrDeviceName, &storage, NULL);

    CarPlayControllerGetBluetoothMacAddress(inController, btMac);
    sprintf (btBuf, "%02x:%02x:%02x:%02x:%02x:%02x",btMac[0],btMac[1],btMac[2],btMac[3],btMac[4],btMac[5]);

    CarPlayControllerCopySourceVersion(inController,&version);
    CFStringGetOrCopyCStringUTF8(version, &cStrDeviceVersion, &storage, NULL);

    auto server = Server::Get(nullptr);
    if(server != nullptr)
    {
        deviceCarplay = new CarPlayDevice();
        deviceCarplay->deviceName = strdup(cStrDeviceName);
        deviceCarplay->btMac = strdup(btBuf);
        deviceCarplay->deviceVersion = strdup(cStrDeviceVersion);///strdup is used which will take care allocating the memory and copying.
        if(deviceCarplay != nullptr && deviceCarplay->deviceName != nullptr && deviceCarplay->btMac != nullptr && deviceCarplay->deviceVersion != nullptr)
        {

            LOG_INFO((dipo,"Update %s Device Name=%s, Bluetooth_MAC=%s, CarPlay_Version=%s", inStatus ? "added" : "removed", deviceCarplay->deviceName,deviceCarplay->btMac,deviceCarplay->deviceVersion));

            if(server->UpdateDevicemap(btBuf, inController, deviceCarplay, inStatus))
            {
                LOG_INFO((dipo, "Device %s map", inStatus ? "added to" : "removed from"));
            }
            else
            {
                LOG_INFO((dipo, "%s Device To Map Failed", inStatus ? "Adding" : "Removing"));
            }

        }
        else
        {
            LOG_ERROR((dipo, "Memory Allocation Failed For New Device."));

        }
    }
    else
    {
        LOG_ERROR((dipo, "_CarPlayControlClientEventCallbackhooks No Active CarPlay Server"));

    }
    free( storage );
    CFRelease( name );
    CFRelease( version );
}


}
